/* Agent Tcl
   Bob Gray
   5 April 1995

   suppHash.h

   This file defines hash table classes.

   Copyright (c) 1995-1998, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _SUPP_HASH_H
#define _SUPP_HASH_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

  /* It is assumed that the data in a hash node is STATICALLY ALLOCATED. */
  /* It will NOT be freed automatically when the hash table is deleted.  */

struct HashNode
{
  long key;            /* integer key                  */
  char *string_key;    /* string key                   */ 
  void *data;          /* pointer to the node data     */ 
  HashNode *next;      /* next node in a list of nodes */

   /* constructor and destructor */

  HashNode (long key, const char *string_key, void *data, HashNode *next);
 ~HashNode ();
};

class Hash
{
    friend class HashSearch;

    unsigned entries;    /* number of entries in the table */
    unsigned max_index;  /* maximum table index            */
    HashNode **table;   /* hash table                     */

    inline long hash (long &key, const char *string_key) const {

       register const char *sp = string_key;

       if (sp != NULL) {
         for (key = 0; *sp != '\0'; sp++) {
           key = (key << 3) + key + *sp;
         }
       }

       return key & max_index;
    }

  public:

      /* constructor and destructor */

    Hash (unsigned entries);
    ~Hash ();

      /* get the number of entries */

    inline unsigned get_entries (void) const { 
 	return entries; 
    }

      /* add, lookup and remove entries */  

    HashNode *add    (long key, const char *string_key, void *data, int &there);
    HashNode *lookup (long key, const char *string_key) const;
    int        remove (long key, const char *string_key); 

      /* empty out the hash table */

    void empty (void);
};

class HashSearch  
{
    Hash *hash;       /* hash table associated with this search */
    unsigned bucket;  /* current bucket of the hash table       */
    HashNode *node;  /* current node of the hash table         */

  public:

	/* constructors */

    HashSearch (Hash *hash);
    HashSearch (const HashSearch &hashSearch);

	/* assignment operator */

    HashSearch &operator= (const HashSearch& hashSearch);

	/* get next node in the hash table */

    HashNode *next (void); 
};

#endif
