/* Agent Tcl
   Bob Gray
   7 March 1998

   referenceCount.h

   This file defines a reference-counting base class.  This class was taken
   from the AP Professional book "C++ for Real Programmers" by Jeff Alger.

   Copyright (c) 1995-1998, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _REFERENCE_COUNT_H
#define _REFERENCE_COUNT_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _PLAT_PORTING_H
#include "platPorting.h"		// NULL
#endif

class ReferenceCount {

    unsigned long m_count;

public:

    ReferenceCount (void):
	m_count (0)
    {
	// empty
    }

    ReferenceCount (const ReferenceCount &):
	m_count (0)
    {
	// empty
    }

    ReferenceCount &operator= (const ReferenceCount &) {
	return (*this);
    }

    virtual ~ReferenceCount () {}

    static void GrabWithoutLock (ReferenceCount *refCount) {
	if (refCount != (ReferenceCount *) NULL) {
	    refCount->m_count += 1;
	}
    }

    void GrabWithoutLock (void) {
	m_count += 1;
    }

    static void Grab (ReferenceCount *refCount) {
	if (refCount != (ReferenceCount *) NULL) {
	    refCount->m_count += 1;
	}
    }

    void Grab (void) {
	m_count += 1;
    }

    static void Release (ReferenceCount *refCount) {

	if (refCount != (ReferenceCount *) NULL) {
	
	    if (refCount->m_count > 0) {
	        refCount->m_count -= 1;
	    }

	    if (refCount->m_count == 0) {
	        delete (refCount);
	    }
	}
    }

    void Release (void) {
	
	if (m_count > 0) {
	    m_count -= 1;
	}

	if (m_count == 0) {
	    delete (this);
	}
    }

    static void GrabAndRelease 
	(ReferenceCount *gcount, ReferenceCount *rcount) {

	if (gcount != (ReferenceCount *) NULL) {
	    gcount->m_count += 1;
	}

	if (rcount != (ReferenceCount *) NULL) {

	    if (rcount->m_count > 0) {
	        rcount->m_count -= 1;
	    }

	    if (rcount->m_count == 0) {
	        delete (rcount);
	    }
	}
    }

    unsigned long checkReferenceCount (void) {
	return (m_count);
    }
};

#endif
