/* Agent Tcl
   Bob Gray
   25 June 1995

   suppStrings.cc

   This file implements convenience routines for working with strings.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef NO_PRAGMAS
#pragma implementation
#endif

#include "platPorting.h"
#include "suppStrings.h"

  // copy a string 

char *strcpyWithAlloc (const char *string)
{
  char *copy = NULL;

  if (string != NULL) {
    copy = new char [strlen(string) + 1];
    strcpy (copy, string);
  }

  return copy;
}

  // strip the whitespace off a string 

char *stripWhitespaceWithAlloc (const char *string)
{
  char *spd;
  int length;
  char *new_string;
  const char *sp;

    /* nothing to do for NULL strings */
  
  if (string == NULL) {
    return NULL;
  }

    /* tear off the leading whitespace */

  for (sp = string; (*sp == ' ') || (*sp == '\t') || (*sp == '\n'); sp++);

  length = strlen(sp);
  new_string = new char [length + 1];
  strcpy (new_string, sp);

    /* tear off the trailing whitespace */

  for (spd = new_string + length - 1; spd >= new_string; spd--) {
    if ((*spd == ' ') || (*spd == '\t') || (*spd == '\n')) {
      *spd = '\0';
    } else {
      break;
    }
  }

  return new_string;
}
