package edu.dartmouth.cs.mydownloader;

import android.Manifest;
import android.app.Activity;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;

// Like this example:
// IntentService (with background thread
// Activity, fragment and IntentService
// file handling (write)
// HTTP client to server
// Broadcast receiver
// You can show the students the "Network" TAB in the Android Monitor stats

public class MainActivity extends Activity {

    //XD: Intent vs Intent Filter: http://developer.android.com/intl/es/guide/components/intents-filters.html
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        checkPermissions(this);

        //XD: check if the fragment container has any fragment
        if (getFragmentManager().findFragmentById(android.R.id.content) == null) {
            getFragmentManager().beginTransaction().add(android.R.id.content,new DownloaderFragment()).commit();
        }

    }

    public void  checkPermissions(Activity activity){
        if(Build.VERSION.SDK_INT < 23)
            return;
        if (ContextCompat.checkSelfPermission(activity, Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED ) {
            ActivityCompat.requestPermissions(activity, new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE}, 0);
        }
    }
}
