package com.xd.demomythreadhandler;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.fragment.app.ListFragment;
import android.widget.ArrayAdapter;

import java.util.ArrayList;

/**
 * Created by Xing-Dong Yang on 1/22/2017.
 */

public class MyListFragment extends ListFragment {
    private ArrayList<String> arrayList;
    private ArrayAdapter<String> arrayAdapter;
    private MessageHandler messageHandler;

    public MyListFragment(){
        //XD: ensure mesageHandler is initialized upon creating an object of ItemFragment.
        messageHandler = new MessageHandler(Looper.getMainLooper());
    }

    public MessageHandler getMsgHandler(){
        return messageHandler;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setRetainInstance(true);
        arrayList = new ArrayList<>();
        arrayAdapter = new ArrayAdapter<String>(getActivity(), android.R.layout.simple_list_item_1, arrayList);
        setListAdapter(arrayAdapter);
    }


    class MessageHandler extends Handler {
        public MessageHandler(Looper looper){
            super(looper);
        }

        @Override
        public void handleMessage(Message msg){
            arrayAdapter.add(msg.getData().getString(ModelFragment.PROF_NAME));
        }
    }
}
